{smcl}

{* *! 1.0.0 2022}{...}
help {hi:weai}
{hline}

{title:Title}


{p2colset 5 17 19 2}{...}
{p 2 2 2} {hi:weai} {hline 2} Computes different versions of the Women's Empowerment in Agricultural Index.
{p2colreset}{...}

{title:Syntax}

{p 8 11 2}{hi:weai} {cmd:d1(}{help varlist}{cmd:)} {cmd:d2(}{help varlist}{cmd:)}  
... {cmd:w1(}{help numlist}{cmd:)} {cmd:w2(}{help numlist}{cmd:)} ... {ifin} {weight}{cmd:,}
{cmdab:c:utoff(}{help it:real}{cmd:)}
{cmdab:s:ex(}{help it:varname}{cmd:)}
{cmdab:f:emale(}{help it:integer}{cmd:)}
{cmdab:m:ale(}{help it:integer}{cmd:)}
{cmdab:hh:id(}{help it:varname}{cmd:)}
{cmdab:d:etails}
{cmd:by(}{help varname}{cmd:)}


{title:Description}

{p 2 2 2} The Women's Empowerment in Agriculture Index (WEAI) is a standardized, survey-based tool that 
has been widely used to track gender equality and measure empowerment, agency, and women's inclusion in 
the agricultural sector 
({browse "https://doi.org/10.1016/j.worlddev.2013.06.007":Alkire et al. 2013}). Since the WEAI's release 
in 2012, an abbreviated version of the WEAI (referred to as A-WEAI) and 
project-level version of the WEAI (referred to as pro-WEAI) have been developed 
({browse "https://www.ifpri.org/publication/abbreviated-womens-empowerment-agriculture-index-weai":Malapit et al. 2017}; 
{browse "https://doi.org/10.1016/j.worlddev.2019.06.018":Malapit et al. 2019}).{p_end} 
{p 2 2 2} Depending on the options specified by the user, {cmd:weai} is capable of computing all versions 
of the WEAI. {cmd:weai} allows for flexibility in the specification of the binary adequacy indicators, 
empowerment cutoff, and indicator weights. {cmd:weai} provides a decomposition by indicator and, when 
specified, by sub-groups. Note that because the WEAI requires data from women and men, users 
are required to specify a variable (and values) identifying the sex of respondents.{p_end}

{marker Outcomes}{...}
{p 2 2 2} Given a suitable set of adequacy indicators, empowerment cutoff, and gender 
variable, {hi:weai} computes the following output:{p_end}

{p 2 2 2}{title:Individual-/household-level indicators:}{p_end}

{phang}
{cmd: empowered}: Empowerment status, a binary indicator that reflects whether a person is empowered. A person 
is considered empowered if his/her empowerment score (the share of weighted indicators in which he/she achieves 
adequacy) is equal to or greater than the empowerment cutoff (see below for details).{p_end}

{phang}
{cmd: emp_score}: Empowerment score, the share of weighted indicators in which a person achieves 
adequacy. Higher values indicate higher levels of adequacy (i.e., empowerment).{p_end}

{phang}
{cmd: gender_parity}: Gender parity status, a binary indicator that reflects whether a 
household achieves gender parity.{p_end}

{phang}
{cmd: hh_ineq}: Intrahousehold inequality score, the difference between the empowerment 
scores of the male and female respondents within the same household. A positive score 
indicates that the man is more empowered than the woman; a negative score indicates that 
the woman is more empowered than the man.{p_end}

{p 2 2 2}{title:Aggregate indices:}{p_end}

{phang}
{cmd: 5/3DE}: Five/Three Domains of Empowerment Index. Based on the Alkire-Foster methodology 
({browse "https://doi.org/10.1016/j.jpubeco.2010.11.006":Alkire and Foster 2011}), the 5/3DE measures 
the prevalence of empowerment and intensity of disempowerment at the individual-level in the sample 
population. It is calculated using the formula: 5/3DE = 1 - (H*A).{p_end}

{phang}
{cmd: H}: Percentage of individuals not achieving empowerment, or the disempowerment headcount ratio. Reflects the 
prevalence of (dis)empowerment among women/men in the sample population. It is the proportion of persons in the 
sample considered to be disempowered based on the empowerment cutoff.{p_end}

{phang}
{cmd: A}: Mean disempowerment score. Reflects the intensity of (dis)empowerment among women/men in the sample 
population. It is the mean share of weighted indicators in which a person does not achieve adequacy, calculated 
only for persons considered to be disempowered based on the empowerment cutoff.{p_end}

{phang}
{cmd: GPI}: Gender Parity Index. The GPI measures two aspects of empowerment at the household-level in the 
sample population: the proportion of households that achieve gender parity and the average empowerment gap 
among households that lack gender parity. A household achieves gender parity if either of the following 
conditions are true: the woman is considered empowered or the woman's empowerment score is equal to or 
greater than the man's empowerment score. It is calculated using the formula: GPI = 1 - (HGPI*IGPI).{p_end}

{phang}
{cmd: HGPI}: Percentage of households not achieving gender parity. Reflects the prevalence of gender parity among 
households in the sample population. It is the proportion of households in the sample considered 
not to have achieved gender parity.{p_end}

{phang}
{cmd: IGPI}: Mean empowerment gap. Reflects the average percentage shortfall that women without gender parity 
experience relative to men in their households. It is the mean (normalized) difference between the empowerment scores of 
the man and woman in a household, calculated among only households that do not achieve gender parity.{p_end}

{phang}
{cmd: WEAI/A-WEAI/pro-WEAI}: Women's Empowerment in Agriculture Index/Abbreviated Women's Empowerment in 
Agriculture Index/Project-level Women's Empowerment in Agriculture Index. The WEAI/A-WEAI/pro-WEAI measures 
women's empowerment in the sample population. It is the weighted average of the 5/3DE and GPI, 
in which the 5/3DE receives 0.9 weight and the GPI receives 0.1 weight.{p_end}


{synoptset 20 tabbed}{...}
{synopthdr}
{synoptline}
{syntab:Main}

{synopt:{opth d1(varlist)} ...}List of empowerment domains, each domain must be 
composed of at least 1 indicator and at least 3 domains must be specified.{p_end}
{synopt:{opth c:utoff(real)}}Empowerment cutoff, a value between 0 and 1, denoting 
the share of weighted indicators in which a person must be adequate to be considered 
empowered; default value is 0.80 (or 80% of the weighted indicators).{p_end}
{synopt:{opth s:ex(varname)}}Variable identifying the gender of respondents.{p_end}
{synopt:{opth f:emale(integer)}}Value assigned to female respondents.{p_end}
{synopt:{opth m:ale(integer)}}Value assigned to male respondents.{p_end}

{syntab:Optional}
{synopt:{opth w1(numlist)} ...}List of weights to be applied to the list of indicators.{p_end}
{synopt:{cmdab:d:etails}}Provides additional tables and figures.{p_end}
{synopt:{opth by(varname)}}Decomposition of all output measures by categories of {help varname}.{p_end}

{synoptline}
{p2colreset}{...}
{p 4 6 2}


{title:Options}

{phang}
{cmd:d1(}{help varlist}{cmd:)} {cmd:d2(}{help varlist}{cmd:)} {cmd:d3(}{help varlist}{cmd:)} ... : denote the empowerment 
domains. At least 1 indicator must be specified for each domain and at least 3 domains must 
be specified. The indicators 
should be binary variables (1 = adequate; 0 = inadequate). Respondents with missing values 
for any indicator are excluded from the estimation sample. The tables below shows the domains, 
indicators, and weights for pro-WEAI, WEAI, and A-WEAI, respectively. Pro-WEAI is comprised of 
10 indicators across 3 domains (intrinsic agency, instrumental agency, and collective 
agency). WEAI is comprised of 10 indicators across 5 domains (production, resources, income, 
leadership, and time). A-WEAI is comprised on 6 indicators across the same 5 domains. Users 
must follow these guidelines in order to correctly calculate the indices. Guidance and 
background information on the construction of the indicators, as well as Stata .do files, 
can be accessed on the {browse "https://weai.ifpri.info/":WEAI Resource Center}.{p_end}

	 {bf:Pro-WEAI}
	{c TLC}{hline 63}{c TRC}
	{c |}  Domain         Indicator                             Weight  {c |}
	{c LT}{hline 63}{c RT}
	{c |}  Intrinsic      Autonomy in income                    1/10    {c |}
	{c |}   agency        Self-efficacy                         1/10    {c |}
	{c |}                 Attitudes about intimate partner      1/10    {c |}
	{c |}                  violence against women                       {c |}
	{c LT}{hline 63}{c RT}
	{c |}  Instrumental   Input in livelihood decisions         1/10    {c |}
	{c |}   agency        Ownership of land and other assets    1/10    {c |}
	{c |}                 Access to and decisions on            1/10    {c |}
	{c |}                  financial services                           {c |}
	{c |}                 Control over use of income            1/10    {c |}
	{c |}                 Work balance                          1/10    {c |}
	{c |}                 Visiting important locations          1/10    {c |}
	{c LT}{hline 63}{c RT}
	{c |}  Collective     Group membership                      1/10    {c |}
	{c |}   agency                                                      {c |}
	{c BLC}{hline 63}{c BRC}

	 {bf:WEAI}
	{c TLC}{hline 63}{c TRC}
	{c |}  Domain       Indicator                               Weight  {c |}
	{c LT}{hline 63}{c RT}
	{c |}  Production   Input in productive decisions           1/10    {c |}
	{c |}               Autonomy in production                  1/10    {c |}
	{c LT}{hline 63}{c RT}
	{c |}  Resources    Ownership of assets                     1/15*   {c |}
	{c |}               Purchase, sale, or transfer of assets   1/15*   {c |}
	{c |}               Access to and decisions about credit    1/15*   {c |}
	{c LT}{hline 63}{c RT}
	{c |}  Income       Control over use of income              1/5     {c |}
	{c LT}{hline 63}{c RT}
	{c |}  Leadership   Group membership                        1/10    {c |}
	{c |}               Speaking in public                      1/10    {c |}
	{c LT}{hline 63}{c RT}
	{c |}  Time         Workload                                1/10    {c |}
	{c |}               Leisure                                 1/10    {c |}
	{c BLC}{hline 63}{c BRC}
	 {bf:NOTE:} * Weights should be specified as w2(0.06667 0.06666 0.06667).
	
	 {bf:A-WEAI}
	{c TLC}{hline 63}{c TRC}
	{c |}  Domain       Indicator                               Weight  {c |}
	{c LT}{hline 63}{c RT}
	{c |}  Production   Input in productive decisions           1/10    {c |}
	{c LT}{hline 63}{c RT}
	{c |}  Resources    Ownership of assets                     2/15**  {c |}
	{c |}               Access to and decisions about credit    1/15**  {c |}
	{c LT}{hline 63}{c RT}
	{c |}  Income       Control over use of income              1/5     {c |}
	{c LT}{hline 63}{c RT}
	{c |}  Leadership   Group membership                        1/10    {c |}
	{c LT}{hline 63}{c RT}
	{c |}  Time         Workload                                1/10    {c |}
	{c BLC}{hline 63}{c BRC}
	 {bf:NOTE:} ** Weights should be specified as w2(0.13333 0.06667).

{phang}
{opth c:utoff(real)} : denotes the empowerment cutoff, or the minimum empowerment score required for 
a person to be considered empowered. specified as a value 
between 0 and 1. For each person {cmd:weai} computes an empowerment score, i.e., the share of weighted 
indicators in which he/she achieves adequacy. A person is considered empowered only if his/her resulting 
score is equal to or greater than the specified empowerment cutoff. If unspecified by the 
user, a default value of 0.80 (or 80% of the weighted indicators) is used, which reflects the 
cutoff used when calculating WEAI, A-WEAI, and pro-WEAI.{p_end}

{pmore}
A modified version of pro-WEAI may be calculated if at least 8 of 10 indicators, 
including at least 1 from each domain, are present in the index. For a modified version 
of pro-WEAI calculated with 8 or 9 indicators, the empowerment cutoff should be 
set at 0.75.{p_end}

{phang}
{cmd:w1(}{help numlist}{cmd:)} {cmd:w2(}{help numlist}{cmd:)} {cmd:w3(}{help numlist}{cmd:)} ... : denote 
the weights used when summing indicators to calculate the empowerment score. 
If unspecified by the user, all indicators receive equal weight (i.e., the 
weighting structure used by pro-WEAI). See above for the weighting structures used by WEAI and A-WEAI.{p_end}

{pmore}
If weights are specified by the user, the following 
requirements apply: (i) weights must be values between 
0 and 1 and must sum to 1; (ii) the number of weights 
must equal the number of indicators; and (iii) weights and indicators must 
be listed in the same order to ensure proper correspondence.{p_end}

{phang}
{cmdab:d:etails} : provides additional tables and figures showing: (i) the uncensored 
inadequcy headcount ratio, i.e., the proportion of women/men in the sample who 
are inadequate in an indicator, regardless of whether they are empowered or disempowered; 
(ii) the censored inadequcy headcount ratio, i.e., the proportion of women/men in 
the sample who are disempowered and simultaneously inadequate in an indicator;  
(iii) the relative contribution of each indicator to disempowerment, calculated 
by multiplying the censored inadequcy headcount ratio by the indicator weight and dividing by the 
disempowerment index (1 - 3/5DE); and (iv) the absolute contribution of each indicator to disempowerment, calculated 
by multiplying the censored inadequcy headcount ratio by the indicator weight. {p_end} 

{phang}
{opth by(varname)} : decomposes all of the output measures by categories of {help varname}. Must 
be numeric. Missing values are excluded from the estimation sample.{p_end}

 
{title:Outputs: Summary results}

{p 2 2 2} The individual-/household-level indicators (i.e., {cmd: empowered}, {cmd: emp_score}, 
{cmd: gender_parity}, and {cmd: hh_ineq}) are saved as new variables in the dataset. The aggregate 
indices (e.g., {cmd: 5/3DE}, {cmd: GPI}, etc.) and related tables are displayed in Stata and exported as a Microsoft Word document 
and saved in the working directory as "Summary results.docx". Related figures are saved in GPH format in 
the working directory as "weai.gph." This allows users to customize the figure(s) as needed using the Stata graph editor. Existing 
copies of these files in the working directory will be overwritten. Users should ensure all such files are 
closed prior to executing the command to avoid an error.  

 
{title:Examples}

{p 2 2 2} Pro-WEAI w/10 indicators: 

{pmore}{cmd: weai} d1(intrin_i1 intrin_i2 intrin_i3) d2(instr_i1 instr_i2 instr_i3 instr_i4 instr_i5 instr_i6) 
d3(col_i1), cutoff(0.8) sex(sex) female(2) male(1) hhid(ID){p_end}

{p 2 2 2} Pro-WEAI w/10 indicators w/details option: 

{pmore}{cmd: weai} d1(intrin_i1 intrin_i2 intrin_i3) d2(instr_i1 instr_i2 instr_i3 instr_i4 instr_i5 instr_i6) 
d3(col_i1), cutoff(0.8) sex(sex) female(2) male(1) hhid(ID) details{p_end}

{p 2 2 2} Pro-WEAI w/9 indicators, missing 1 intrinsic agency indicator:{p_end}

{pmore}{cmd: weai} d1(intrin_i1 intrin_i2) d2(instr_i1 instr_i2 instr_i3 instr_i4 instr_i5 instr_i6) 
d3(col_i1), cutoff(0.75) sex(sex) female(2) male(1) hhid(ID){p_end}

{p 2 2 2} Pro-WEAI w/8 indicators, missing 1 intrinsic agency indicator and 1 instrumental agency indicator:{p_end}

{pmore} {cmd: weai} d1(intrin_i1 intrin_i2) d2(instr_i1 instr_i2 instr_i3 instr_i4 instr_i5) d3(col_i1), 
cutoff(0.75) sex(sex) female(2) male(1) hhid(ID){p_end}

{p 2 2 2} Pro-WEAI w/10 indicators by treatment arm:{p_end} 
{pmore} {cmd: weai} d1(intrin_i1 intrin_i2 intrin_i3) d2(instr_i1 instr_i2 instr_i3 instr_i4 instr_i5 instr_i6) 
d3(col_i1), cutoff(0.8) sex(sex) female(2) male(1) by(treatment) hhid(ID){p_end}

{p 2 2 2} WEAI w/10 indicators:{p_end}

{pmore} {cmd: weai} d1(prod_i1 prod_i2) d2(resource_i1 resource_i2 resource_i3) d3(income_i1) 
d4(time_i1 time_i2) d5(leader_i1 leader_i2) w1(0.1 0.1) w2(0.06667 0.06666 0.06667) w3(0.2) 
w4(0.1 0.1) w5(0.1 0.1), cutoff(0.8) sex(sex) female(2) male(1) hhid(ID){p_end}

{p 2 2 2} WEAI w/10 indicators by region:

{pmore} {cmd: weai} d1(prod_i1 prod_i2) d2(resource_i1 resource_i2 resource_i3) d3(income_i1) 
d4(time_i1 time_i2) 
d5(leader_i1 leader_i2) w1(0.1 0.1) w2(0.06667 0.06666 0.06667) w3(0.2) w4(0.1 0.1) w5(0.1 0.1), 
cutoff(0.8) sex(sex) female(2) male(1) by(region) hhid(ID){p_end}

{p 2 2 2} WEAI w/10 indicators by region w/details option:

{pmore} {cmd: weai} d1(prod_i1 prod_i2) d2(resource_i1 resource_i2 resource_i3) d3(income_i1) 
d4(time_i1 time_i2) 
d5(leader_i1 leader_i2) w1(0.1 0.1) w2(0.06667 0.06666 0.06667) w3(0.2) w4(0.1 0.1) w5(0.1 0.1), 
cutoff(0.8) sex(sex) female(2) male(1) by(region) hhid(ID) details{p_end}

{p 2 2 2} A-WEAI with 6 indicators:{p_end}

{pmore} {cmd: weai} d1(prod_i1) d2(resource_i1 resource_i3) d3(income_i1) d4(time_i1) d5(leader_i1) 
w1(0.2) w2(0.13333 0.06667) w3(0.2) w4(0.2) w5(0.2), cutoff(0.8) sex(sex) female(2) male(1) hhid(ID){p_end}

{p 2 2 2} A-WEAI w/6 indicators by rural/urban:{p_end} 
{pmore} {cmd: weai} d1(prod_i1) d2(resource_i1 resource_i3) d3(income_i1) d4(time_i1) d5(leader_i1) 
w1(0.2) w2(0.13333 0.06667) w3(0.2) w4(0.2) w5(0.2), cutoff(0.8) sex(sex) female(2) male(1)  by(rural) hhid(ID){p_end}


{title:References}

{p 2 2 2} Alkire, S., & Foster, J. (2011). Counting and multidimensional poverty measurement. 
{it:Journal of Public Economics}, 95(7–8), 476–487. {browse "https://doi.org/10.1016/j.jpubeco.2010.11.006"} {p_end} 
{p 2 2 2}  
Alkire, S., Meinzen-Dick, R., Peterman, A., Quisumbing, A., Seymour, G., & Vaz, A. (2013). The 
Women's Empowerment in Agriculture Index. {it:World Development}, 52, 
71–91. {browse "https://doi.org/10.1016/j.worlddev.2013.06.007"} {p_end}

{p 2 2 2} Malapit, H., Quisumbing, A., Meinzen-Dick, R., Seymour, G., Martinez, E., Heckert, J., 
Rubin, D., Vaz, A., & Yount, K. (2019). Development of the project-level Women's Empowerment 
in Agriculture Index (pro-WEAI). {it:World Development}, 122, 675–692. 
{browse "https://doi.org/10.1016/j.worlddev.2019.06.018"}{p_end}

{p 2 2 2} Malapit, H., Pinkstaff, C., Sproule, K., Kovarik, C., Quisumbing, A., & Meinzen-Dick, R. 
(2017). The Abbreviated Women' s Empowerment in Agriculture Index (A-WEAI). 
IFPRI Discussion Paper, No. 1647. Washington, DC: International Food Policy Research 
Institute 
(IFPRI). {browse "https://www.ifpri.org/publication/abbreviated-womens-empowerment-agriculture-index-weai"}{p_end}


{title:Authors}

{p 2 2 2} 
Malick Dione, International Food Policy Research Institute{p_end}

{p 2 2 2} 
Greg Seymour, International Food Policy Research Institute{p_end}

{p 2 2 2} 
Hazel Malapit, International Food Policy Research Institute{p_end}


{title:For more information visit the WEAI Resource Center}

{p 2 2 2}  
{browse "https://weai.ifpri.info/":https://weai.ifpri.info/}{p_end}


{title:Contact us}

{p 2 2 2} 
{browse "mailto:IFPRI-WEAI@cgiar.org":IFPRI-WEAI@cgiar.org}{p_end}


